package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.ImageObserver;

public class LevelStartPaletteObject extends ScreenPaletteObject {
	
	private static CustomImageDataII enabled;
	private static CustomImageDataII disabled;
	
	private LevelStartScreenObject createdObject;
	
	public static synchronized void ensureImagesAreAvailable(ImageObserver io) {
		if(enabled == null) {
			enabled = new CustomImageDataII("/images/levelStart.GIF", Color.white, io);
		}
		if(disabled == null) {
			disabled = new CustomImageDataII("/images/levelStartDisabled.GIF", Color.white, io);
		}
	}
	

	public LevelStartPaletteObject(IntRect theClickRect, int theDistanceToBorder, int theBorderWidth, RoomEditorPanel theEditorPanel) {
		
		ensureImagesAreAvailable(theEditorPanel);
		
		clickRect = theClickRect;
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		editorPanel = theEditorPanel;
		
	}

	
	
	@Override
	public ScreenObject create(int objX, int objY, ImageObserver io) {
		createdObject = new LevelStartScreenObject(objX, objY, this);
		return createdObject;
	}

	@Override
	public void delete(ScreenObject so) {
		createdObject = null;
	}

	@Override
	public void draw(Graphics g) {
		
		if(clickRect == null || editorPanel == null)
			return;
		
		
		CustomImageDataII image = retrieveAppropriateImage();
		
		image.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		Color origCol = g.getColor();
		
		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
		
	}
	
	public CustomImageDataII retrieveAppropriateImage() {
		if(editorPanel.isStartRoom()) {
			return enabled;
		} else {
			return disabled;
		}
	}
	
	public static int getImageWidth(ImageObserver io) {
		ensureImagesAreAvailable(io);
		
		return enabled.getDesiredWidth();
	}
	
	public static int getImageHeight(ImageObserver io) {
		ensureImagesAreAvailable(io);
		
		return enabled.getDesiredHeight();
	}
	
	public boolean screenObjectAlreadyExists() {
		return createdObject != null;
	}
	
}
